#pragma once

#include <string>

namespace Vape {

enum class PlaceholderType {
    Glitch,
    Bars100,
    Bars75,
    Black,
};

inline PlaceholderType
GetPlaceholderType(const std::string &name)
{
    if (name == "glitch") {
        return PlaceholderType::Glitch;
    }

    if (name == "bars100") {
        return PlaceholderType::Bars100;
    }

    if (name == "bars75") {
        return PlaceholderType::Bars75;
    }

    if (name == "black") {
        return PlaceholderType::Black;
    }

    // Fallback
    return PlaceholderType::Glitch;
}

}  // namespace Vape
