#include "./twitch-logo.hpp"

#include "./stb_image.h"
#include "debug/log.hpp"

#include <cassert>

namespace Vape {
const std::string h{"TwitchLogo"};

// A 100x117 black and white PNG of a Twitch Glitch
static const uint8_t glitchPNG[] = {
    0x89, 0x50, 0x4E, 0x47, 0x0D, 0x0A, 0x1A, 0x0A, 0x00, 0x00, 0x00, 0x0D, 0x49, 0x48, 0x44, 0x52,
    0x00, 0x00, 0x00, 0x64, 0x00, 0x00, 0x00, 0x75, 0x08, 0x04, 0x00, 0x00, 0x00, 0x12, 0x61, 0x8C,
    0xE1, 0x00, 0x00, 0x00, 0x04, 0x67, 0x41, 0x4D, 0x41, 0x00, 0x00, 0xB1, 0x8F, 0x0B, 0xFC, 0x61,
    0x05, 0x00, 0x00, 0x00, 0x20, 0x63, 0x48, 0x52, 0x4D, 0x00, 0x00, 0x7A, 0x26, 0x00, 0x00, 0x80,
    0x84, 0x00, 0x00, 0xFA, 0x00, 0x00, 0x00, 0x80, 0xE8, 0x00, 0x00, 0x75, 0x30, 0x00, 0x00, 0xEA,
    0x60, 0x00, 0x00, 0x3A, 0x98, 0x00, 0x00, 0x17, 0x70, 0x9C, 0xBA, 0x51, 0x3C, 0x00, 0x00, 0x00,
    0x02, 0x62, 0x4B, 0x47, 0x44, 0x00, 0xFF, 0x87, 0x8F, 0xCC, 0xBF, 0x00, 0x00, 0x00, 0x09, 0x70,
    0x48, 0x59, 0x73, 0x00, 0x00, 0x0B, 0x12, 0x00, 0x00, 0x0B, 0x12, 0x01, 0xD2, 0xDD, 0x7E, 0xFC,
    0x00, 0x00, 0x00, 0x07, 0x74, 0x49, 0x4D, 0x45, 0x07, 0xE5, 0x04, 0x08, 0x0A, 0x38, 0x1D, 0xC3,
    0x67, 0xFB, 0x4A, 0x00, 0x00, 0x05, 0x70, 0x49, 0x44, 0x41, 0x54, 0x78, 0xDA, 0xED, 0xDC, 0xCB,
    0x6F, 0xDC, 0x44, 0x1C, 0xC0, 0xF1, 0xEF, 0xD8, 0x5E, 0xA4, 0x42, 0x29, 0x6D, 0x79, 0x1C, 0x28,
    0x07, 0xA4, 0x96, 0x97, 0x04, 0x05, 0xCA, 0x8D, 0x03, 0x08, 0x94, 0x96, 0xF6, 0x2F, 0xE0, 0x16,
    0xDE, 0x7F, 0x02, 0x6A, 0x29, 0x49, 0x0A, 0x7D, 0x9C, 0x10, 0x17, 0x84, 0x38, 0xF0, 0x6A, 0x0B,
    0x27, 0x24, 0xF8, 0x0F, 0x10, 0x9C, 0x78, 0x88, 0xB6, 0x47, 0xDA, 0x82, 0x84, 0x78, 0x35, 0x50,
    0xDA, 0x40, 0x28, 0x22, 0x52, 0x48, 0x3C, 0xF3, 0xE3, 0xE0, 0x75, 0xBC, 0xEB, 0x1D, 0x3F, 0x37,
    0xDE, 0xF5, 0x54, 0xFB, 0xF3, 0x29, 0xF6, 0x64, 0x33, 0x1F, 0xFF, 0x7E, 0xBB, 0x9E, 0x99, 0xD8,
    0x0B, 0xF9, 0xA1, 0x00, 0x0F, 0x1F, 0xF8, 0x04, 0x41, 0x23, 0xAD, 0xDD, 0x4A, 0x32, 0x4E, 0xB6,
    0x9C, 0x21, 0xE5, 0x18, 0x1F, 0x22, 0x84, 0x63, 0xEF, 0x6A, 0x4D, 0x48, 0xC2, 0xF8, 0x00, 0x61,
    0x75, 0xEC, 0x1D, 0xAD, 0x09, 0xE9, 0x2F, 0xAA, 0xF6, 0x33, 0xE4, 0x6A, 0x61, 0x48, 0x60, 0x65,
    0x08, 0x1E, 0x0A, 0xCD, 0x09, 0xA6, 0x09, 0x49, 0xB5, 0xF1, 0x19, 0x7F, 0x08, 0xA6, 0xB0, 0x4D,
    0x92, 0x8D, 0x13, 0xAE, 0x64, 0xC3, 0x96, 0x91, 0x24, 0x1B, 0xC7, 0x79, 0x6A, 0x30, 0x1B, 0x70,
    0x1D, 0xAF, 0xB3, 0x89, 0x10, 0x35, 0xB6, 0x6C, 0x18, 0x36, 0xF2, 0x39, 0x6F, 0xE2, 0xE5, 0x64,
    0x25, 0xC9, 0xC6, 0x71, 0x5B, 0x36, 0x94, 0x20, 0x5B, 0xE4, 0x4F, 0x11, 0xD1, 0x32, 0xBE, 0x58,
    0x15, 0x91, 0x8F, 0x04, 0xF1, 0x33, 0x33, 0x92, 0x64, 0xE3, 0x7D, 0x9E, 0xB6, 0x65, 0x23, 0x0A,
    0x0D, 0xE8, 0x12, 0x35, 0xDA, 0x54, 0x84, 0x04, 0xE8, 0x81, 0xBD, 0x49, 0x67, 0x13, 0xC6, 0x7B,
    0x3C, 0x93, 0xCD, 0x88, 0xDE, 0xEC, 0x3E, 0xDE, 0xD8, 0x20, 0x71, 0x1F, 0xFA, 0x23, 0xEE, 0x4F,
    0x2F, 0xE3, 0xD9, 0x3C, 0x46, 0x5B, 0xC3, 0x4B, 0x31, 0xDE, 0x75, 0x93, 0x11, 0x41, 0x7A, 0x19,
    0xCF, 0xB9, 0xC9, 0x00, 0xAF, 0x87, 0xF1, 0x8E, 0xBB, 0x0C, 0xF0, 0xD6, 0x18, 0x6F, 0xF3, 0xBC,
    0xBB, 0x0C, 0xF0, 0xD6, 0x18, 0x2F, 0xB8, 0xCC, 0xE0, 0x6A, 0x61, 0x80, 0x87, 0xE6, 0x2D, 0xF7,
    0x19, 0x10, 0x70, 0x92, 0x69, 0x74, 0x13, 0x0C, 0x41, 0x59, 0x26, 0x0A, 0x0A, 0x85, 0x58, 0x46,
    0x6A, 0xD5, 0x5A, 0xDB, 0x20, 0xD3, 0x98, 0x66, 0x46, 0xE6, 0xAA, 0xDB, 0x11, 0xFB, 0x91, 0xE1,
    0x5A, 0xDB, 0x20, 0xA6, 0xA9, 0xD1, 0x86, 0xA0, 0xD0, 0x2C, 0xF6, 0x9D, 0x65, 0x61, 0x33, 0xD7,
    0x64, 0x66, 0x24, 0x64, 0x31, 0xB5, 0x77, 0x0B, 0x41, 0xE9, 0x8C, 0x34, 0x36, 0x68, 0x12, 0x14,
    0xF3, 0xEC, 0xE2, 0x3F, 0xFC, 0x2E, 0xC6, 0xE3, 0x5F, 0x3E, 0xE5, 0x51, 0x6B, 0x09, 0x18, 0x7C,
    0xCE, 0xF2, 0x30, 0x01, 0x20, 0x44, 0x79, 0x08, 0xF9, 0x92, 0x9D, 0x25, 0x0B, 0xA6, 0xE1, 0xB7,
    0xB8, 0xE1, 0x1F, 0x56, 0xD7, 0x7E, 0xF2, 0x30, 0xE8, 0x6E, 0x47, 0xED, 0xAD, 0x97, 0x06, 0xF6,
    0x94, 0x8D, 0xC6, 0x3F, 0xAB, 0x14, 0x49, 0x95, 0x97, 0x29, 0x91, 0xDE, 0x36, 0x52, 0xA2, 0xFD,
    0xC8, 0x20, 0xD2, 0xD3, 0xA1, 0x32, 0x1D, 0xAB, 0xD2, 0xF9, 0xDE, 0x18, 0xEF, 0xB4, 0x62, 0x1D,
    0x63, 0x02, 0x69, 0x5B, 0x4C, 0x20, 0x6D, 0x8B, 0x09, 0xA4, 0x6D, 0x31, 0x81, 0xB4, 0x2D, 0x26,
    0x90, 0xB6, 0xC5, 0x04, 0xD2, 0xB6, 0x98, 0x40, 0xDA, 0x16, 0x13, 0x48, 0xDB, 0x62, 0x02, 0x29,
    0x1B, 0xC9, 0x9C, 0x5D, 0x95, 0x9C, 0xB3, 0x57, 0x69, 0x9D, 0xC4, 0x08, 0xE7, 0xEC, 0x52, 0x69,
    0xCE, 0x5E, 0x75, 0xEE, 0xDE, 0x30, 0x44, 0xB1, 0x01, 0xAF, 0x67, 0x5D, 0x6B, 0xA9, 0xFB, 0x9F,
    0x25, 0x7B, 0x78, 0x74, 0xE8, 0xAC, 0x11, 0x14, 0xAB, 0x15, 0x0A, 0xA6, 0x41, 0x88, 0x02, 0xB6,
    0x71, 0xAE, 0xE7, 0xDC, 0x2A, 0x0C, 0x37, 0x63, 0xAF, 0x67, 0x0F, 0xB8, 0x87, 0x1F, 0x53, 0x7B,
    0x6F, 0xA1, 0x6C, 0xF5, 0x37, 0x0C, 0x09, 0xB8, 0x35, 0xE3, 0x88, 0x6D, 0x5F, 0x87, 0x6D, 0x25,
    0x5B, 0x8F, 0x14, 0x32, 0xEA, 0xD5, 0xF8, 0xC6, 0x62, 0xB4, 0xAB, 0xF1, 0xCE, 0x5D, 0x47, 0xA2,
    0x9C, 0x0D, 0xAE, 0x09, 0x3B, 0x06, 0x89, 0x0A, 0xD0, 0xD6, 0x6D, 0xA7, 0x20, 0x31, 0x03, 0xBE,
    0x70, 0x19, 0x12, 0x31, 0x34, 0x1D, 0x66, 0xE4, 0x0D, 0x54, 0xEA, 0xC6, 0x1A, 0x67, 0x20, 0x31,
    0x23, 0x60, 0x56, 0x8E, 0x29, 0x3F, 0xFD, 0xF9, 0x26, 0x8E, 0x40, 0x12, 0xC6, 0x9C, 0x1C, 0x55,
    0x03, 0xB7, 0x39, 0x89, 0x23, 0x19, 0x89, 0x18, 0x21, 0x01, 0x73, 0x72, 0x44, 0x05, 0x84, 0xFD,
    0x87, 0x0D, 0x8A, 0x0B, 0x0E, 0x40, 0x62, 0x46, 0x87, 0x43, 0x36, 0x86, 0xC6, 0xE3, 0x07, 0xA6,
    0xA8, 0x72, 0x03, 0xE4, 0x38, 0x6E, 0x05, 0x34, 0x22, 0x62, 0x64, 0x45, 0x44, 0xE6, 0x0C, 0x12,
    0xA4, 0xFB, 0x14, 0x22, 0xFC, 0xCC, 0xF6, 0x08, 0xDC, 0x62, 0x48, 0xC2, 0x38, 0x94, 0xC5, 0xF8,
    0x89, 0x1D, 0x40, 0xD0, 0x6A, 0x48, 0xC2, 0x78, 0x25, 0x3B, 0x1B, 0x5D, 0x46, 0x8B, 0x21, 0x95,
    0x18, 0xAA, 0xB5, 0x90, 0x84, 0xF1, 0x6A, 0x16, 0xE3, 0x17, 0xEE, 0x48, 0x18, 0x2D, 0x85, 0x24,
    0x8C, 0xC3, 0x26, 0x7D, 0x87, 0xAF, 0x9D, 0xD1, 0x4A, 0x48, 0x29, 0xC6, 0x9D, 0xFD, 0x8C, 0x16,
    0x42, 0x12, 0xC6, 0x91, 0x2C, 0xC6, 0xAF, 0x83, 0x8C, 0x1A, 0x13, 0x2B, 0xA1, 0xCC, 0x8A, 0x48,
    0xD6, 0xCC, 0x2E, 0x19, 0xC1, 0x66, 0x87, 0x41, 0xD3, 0xE1, 0xA8, 0xCC, 0x2A, 0x3F, 0x3D, 0x18,
    0xD1, 0xF8, 0x5C, 0x60, 0x8A, 0xEF, 0x09, 0x08, 0xFB, 0x5F, 0x6A, 0xA4, 0x19, 0x31, 0x22, 0x12,
    0x76, 0xCF, 0x79, 0x76, 0x1B, 0x2D, 0x22, 0x47, 0xB3, 0xB3, 0x71, 0x57, 0x3A, 0x1B, 0xB5, 0x32,
    0x22, 0x2C, 0x71, 0x2D, 0x2B, 0x39, 0x13, 0x50, 0x85, 0x10, 0xB0, 0x81, 0xF8, 0x66, 0xA5, 0xFE,
    0x6C, 0x68, 0x3C, 0x96, 0xD3, 0x27, 0x33, 0x95, 0x8F, 0x8D, 0x1C, 0x93, 0x19, 0x7B, 0x36, 0xE6,
    0x99, 0xE2, 0xBB, 0xC1, 0x6C, 0x50, 0x22, 0xCF, 0x03, 0xDD, 0xBC, 0xA9, 0x60, 0xA4, 0xE9, 0x71,
    0x85, 0x7D, 0x7C, 0x8C, 0x49, 0xCD, 0xC1, 0x05, 0xC5, 0x2A, 0x1D, 0xBE, 0x92, 0x27, 0xD5, 0x72,
    0xEE, 0x6B, 0x08, 0x0B, 0x83, 0xC5, 0x1B, 0x33, 0xCE, 0xDB, 0x18, 0xD1, 0x6F, 0xAD, 0xF3, 0xE6,
    0x0B, 0xF2, 0xD8, 0x5A, 0x09, 0xF5, 0x16, 0xD5, 0x8A, 0x88, 0x7C, 0x6D, 0x6E, 0xE8, 0x16, 0x69,
    0xDE, 0xE6, 0xD9, 0x8A, 0x6A, 0x9E, 0xBB, 0xB1, 0x14, 0x55, 0x14, 0x35, 0xDE, 0xEC, 0x45, 0xAB,
    0x1A, 0xCA, 0xD2, 0x26, 0xCE, 0xC6, 0x37, 0xB2, 0x57, 0x5D, 0xC1, 0xC7, 0x14, 0xBC, 0x4A, 0x6A,
    0x71, 0x41, 0xE3, 0xF3, 0x5B, 0x5E, 0x36, 0x6A, 0x7F, 0x6A, 0x15, 0x1D, 0x97, 0xD4, 0x9E, 0x98,
    0xF1, 0x84, 0xFA, 0x1B, 0xCF, 0xF2, 0xF4, 0x47, 0x6E, 0xC4, 0x8C, 0x73, 0xD9, 0x8C, 0x91, 0x4C,
    0xAC, 0x62, 0xC6, 0xA9, 0x2E, 0xA3, 0xE2, 0x23, 0x34, 0x1A, 0x9F, 0xDF, 0xD9, 0x9D, 0xCF, 0x18,
    0x01, 0x24, 0x61, 0xEC, 0xA9, 0xCF, 0x98, 0xE2, 0x6C, 0x3E, 0xA3, 0x71, 0x48, 0xCC, 0x38, 0x5D,
    0x3F, 0x1B, 0x17, 0xD9, 0x5D, 0xCC, 0x68, 0x1C, 0x12, 0x33, 0xF6, 0xA8, 0xC5, 0xEA, 0x0C, 0x83,
    0xCF, 0x45, 0xA6, 0xF8, 0xB6, 0x98, 0xD1, 0x30, 0x24, 0x62, 0x9C, 0xA9, 0xCB, 0xF0, 0xCA, 0x33,
    0xA0, 0xC1, 0xEB, 0x88, 0x96, 0x15, 0x11, 0x39, 0x6D, 0xB6, 0xDA, 0xAE, 0x0B, 0x45, 0x9B, 0x46,
    0xB8, 0xC8, 0xBD, 0x64, 0x5E, 0x37, 0x46, 0x08, 0x59, 0x16, 0x91, 0x33, 0x23, 0x63, 0x34, 0x04,
    0x79, 0x5C, 0x64, 0x58, 0xC6, 0x7D, 0xD5, 0x18, 0x0D, 0x40, 0x3C, 0x41, 0x1E, 0x11, 0x91, 0x53,
    0xE6, 0xC6, 0xBA, 0x8C, 0x3F, 0xAA, 0x33, 0x1A, 0xCA, 0xC8, 0x3E, 0x39, 0x6F, 0xB6, 0xD4, 0x67,
    0xEC, 0xAC, 0xCE, 0x68, 0x00, 0xA2, 0x04, 0xD9, 0x2E, 0xB7, 0x8F, 0x98, 0xD1, 0x00, 0x24, 0xE6,
    0x14, 0x8D, 0x70, 0xAD, 0x8C, 0x4B, 0xDC, 0x5F, 0x8F, 0xD1, 0x10, 0x64, 0xF4, 0x8C, 0xC6, 0x32,
    0x52, 0x8B, 0xF1, 0x40, 0x7D, 0x46, 0x3B, 0x20, 0x1A, 0xE1, 0xF2, 0x70, 0x8C, 0x36, 0x40, 0x22,
    0xC6, 0x83, 0xC3, 0x31, 0xC6, 0x0F, 0x59, 0x27, 0xC6, 0xB8, 0x21, 0x1A, 0x61, 0x81, 0x5D, 0xC3,
    0x33, 0xC6, 0x0B, 0x49, 0x18, 0x9D, 0x61, 0x19, 0x4D, 0x42, 0x8A, 0xBE, 0x34, 0xC9, 0x20, 0x2C,
    0xF0, 0xD0, 0xFA, 0x30, 0x82, 0x1A, 0xDF, 0x42, 0x51, 0x6E, 0x0E, 0x63, 0x0A, 0xA6, 0x20, 0x82,
    0xCF, 0x02, 0x7B, 0x39, 0x43, 0x87, 0xD5, 0xEA, 0xEB, 0x6B, 0xE9, 0x50, 0xEC, 0xA8, 0xD4, 0x3A,
    0x64, 0x2B, 0x9F, 0xB1, 0xA9, 0xB0, 0xA5, 0xC6, 0xE7, 0x20, 0x27, 0xB9, 0x3E, 0x67, 0xC9, 0xC4,
    0x67, 0x91, 0x4B, 0xF8, 0xE8, 0xE1, 0x19, 0x55, 0xC3, 0x03, 0xB6, 0xF2, 0x57, 0xB7, 0x2C, 0xB2,
    0xB7, 0x10, 0xE1, 0x45, 0xA2, 0x87, 0xCC, 0xB3, 0x4F, 0x0A, 0x28, 0x7C, 0x86, 0x2E, 0xAA, 0x28,
    0xAA, 0x3D, 0xE2, 0xEA, 0x95, 0x7A, 0xB2, 0x57, 0xE3, 0xB3, 0x9F, 0xD7, 0xE8, 0x60, 0x72, 0xBB,
    0xE9, 0x21, 0xE3, 0xC8, 0x46, 0xF4, 0xA7, 0x8B, 0x33, 0x12, 0x22, 0xEC, 0x07, 0x3A, 0xD6, 0x25,
    0xC7, 0x96, 0x44, 0x31, 0xC4, 0x09, 0x46, 0x31, 0x24, 0x44, 0x38, 0xD0, 0x7E, 0x46, 0x11, 0xC4,
    0x19, 0x46, 0x3E, 0x24, 0x44, 0x78, 0xC9, 0x0D, 0x46, 0x1E, 0x24, 0x44, 0x38, 0xE8, 0x0A, 0x23,
    0x1B, 0xE2, 0x18, 0x23, 0x0B, 0x12, 0x22, 0xBC, 0xEC, 0x12, 0xC3, 0x0E, 0x71, 0x90, 0x61, 0x83,
    0x84, 0x08, 0x33, 0xAE, 0x31, 0x06, 0x21, 0x21, 0xC2, 0xAC, 0x7B, 0x8C, 0x34, 0xC4, 0x59, 0x46,
    0x3F, 0x24, 0x44, 0x98, 0x73, 0x93, 0xD1, 0x0B, 0x59, 0x71, 0x99, 0xD1, 0x0B, 0x11, 0x0E, 0xB9,
    0xCB, 0x88, 0x21, 0x97, 0x5D, 0x67, 0x44, 0x90, 0xCD, 0x2C, 0x71, 0x18, 0x08, 0xDC, 0x65, 0x44,
    0x90, 0xDB, 0x38, 0xD0, 0x46, 0xC6, 0xFF, 0x5E, 0xC2, 0xB6, 0xDA, 0xE6, 0x58, 0xA8, 0x0D, 0x00,
    0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3A, 0x63, 0x72, 0x65, 0x61,
    0x74, 0x65, 0x00, 0x32, 0x30, 0x32, 0x31, 0x2D, 0x30, 0x34, 0x2D, 0x30, 0x38, 0x54, 0x31, 0x30,
    0x3A, 0x35, 0x36, 0x3A, 0x31, 0x33, 0x2B, 0x30, 0x30, 0x3A, 0x30, 0x30, 0x9D, 0xCB, 0xB7, 0xEF,
    0x00, 0x00, 0x00, 0x25, 0x74, 0x45, 0x58, 0x74, 0x64, 0x61, 0x74, 0x65, 0x3A, 0x6D, 0x6F, 0x64,
    0x69, 0x66, 0x79, 0x00, 0x32, 0x30, 0x32, 0x31, 0x2D, 0x30, 0x34, 0x2D, 0x30, 0x38, 0x54, 0x31,
    0x30, 0x3A, 0x35, 0x36, 0x3A, 0x31, 0x33, 0x2B, 0x30, 0x30, 0x3A, 0x30, 0x30, 0xEC, 0x96, 0x0F,
    0x53, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4E, 0x44, 0xAE, 0x42, 0x60, 0x82,
};

static Image
DecodeTwitchLogo()
{
    Image image;

    int channels = 0;
    auto data    = stbi_load_from_memory(glitchPNG, sizeof(glitchPNG), &image.width, &image.height,
                                      &channels, 2);

    if (data) {
        if (image.width == 100 && image.height == 117 && channels == 2) {
            size_t pCount = image.width * image.height;
            image.data.reserve(pCount);

            for (size_t i = 0; i < pCount; ++i) {
                uint8_t y = data[i * 2];
                uint8_t a = data[i * 2 + 1];
                image.data.emplace_back(Pixel::FromMonochrome(y, a));
            }

            // According to the brand guidelines the margin is half the width of the image
            // on all sides of the body, ignoring the pointy bit at the bottom
            image.margin.top    = image.width / 2;
            image.margin.right  = image.width / 2;
            image.margin.left   = image.width / 2;
            image.margin.bottom = image.width / 2 - (image.height - image.width);
        } else {
            Log::TError(h, "Decoded glitch image, but wrong parameters w:{}, h{}, c:{}",
                        image.width, image.height, channels);
            image.width  = 0;
            image.height = 0;
        }

        stbi_image_free(data);
    } else {
        Log::TError(h, "Failed to load Twitch glitch");
    }

    assert(!image.data.empty() && image.width == 100 && image.height == 117);

    return image;
}

Image &
GetTwitchLogo()
{
    static Image image = DecodeTwitchLogo();
    return image;
}

}  // namespace Vape
