#include "./app.hpp"
#include "./config.hpp"
#include "./version.hpp"
#include "debug/log.hpp"
#include "fundamentals/helpers.hpp"
#include "thread-helpers/thread-helpers.hpp"

#include <csignal>
#include <iostream>

using namespace std;
using namespace Vape;

int
main(int argc, char **argv)
{
    RenameThread("VMS Main");
    Log::Starter logInstance;

    auto versionString =
        fS("Multistream {}, built {}, {}", Multistream::VERSION, __DATE__, __TIME__);

    if (argc >= 2) {
        if (strcmp(argv[1], "--version") == 0) {
            std::cerr << versionString << "\n";
            return 0;
        }
    }

    const auto &c = Config::Get();

    Log::Info(versionString);

    if (c.outputType.empty()) {
        Log::Error("Missing required VAPOUR_MULTISTREAM_OUTPUT_TYPE environment variable");
        return EXIT_FAILURE;
    }

    Application instance;
    instance.Start();

    return EXIT_SUCCESS;
}
