#pragma once

#include "../consumer/ivideooutputconsumer.hpp"
#include "../consumer/output-type.hpp"
#include "../credentials/manager.hpp"
#include "../settings/manager.hpp"
#include "../stop-reason.hpp"
#include "consumer/consumer-manager.hpp"
#include "fundamentals/signal-listener.hpp"
#include "fundamentals/signal-provider.hpp"
#include "quitter/quitter.hpp"
#include "vapour-player-core/listener.hpp"

#include <condition_variable>
#include <memory>
#include <mutex>
#include <string>

namespace Vape {
namespace PubSub {
class Client;
}

class StatusManager;
class SettingsManager;

class Player
{
    const std::string h;

    const OutputType outputType;
    PlayerCore::Listener fetcher;

public:
    struct StartLock {
        std::mutex mutex;
        std::condition_variable cv;
        bool initialized;
    };

    Player(SettingsManager &settingsManager, Signal::Group &signalGroup,
           Signal::ListenerPtrList &signalList, API::Client &apiClient);
    ~Player();

    Quitter quitter;
    ConsumerManager consumerManager;

    /**
     * Attempts to play back a stream, and returns when the attempt fails, when a stream has ended
     * or when a quitter has been triggered externally
     * This call should be run in a new thread by the caller
     * @param settingsManager The instance of settings manager to get the parameters from
     * @param statusManager The instance of status manager to report playback status to
     * @param credentialsManager The instance of credentials manager to query client key and token from
     * @param startLock Reference to the struct containing the conditional variable to signal initialization
     */
    StopReason Run(SettingsManager &settingsManager, StatusManager &statusManager,
                   CredentialsManager &credentialsManager, StartLock &startLock);

    Signal::Provider<> startedSignal;
    Signal::Provider<StopReason> stopSignal;
};

}  // namespace Vape
