#pragma once

#include "../constants.hpp"
#include "vapour-player-core/time.hpp"

#include <atomic>
#include <functional>
#include <mutex>

namespace Vape {

class PlaybackRateMonitor
{
public:
    PlaybackRateMonitor();
    ~PlaybackRateMonitor();

    float CalculatePlaybackRateFromOffset(float offset);
    void SetToStarted();
    void SetOffsetMultiplier(float mul);
    void SetOffsetClamp(float lo, float hi);
    void SetAggressiveOffsetClamp(float lo, float hi);
    void SetMinOffset(float min);

    void UseAggressive();

private:
    struct ClampValues {
        float lo, hi;
    };

    bool started;
    float multiplier;
    ClampValues clamp;
    ClampValues aggressiveClamp;
    float minOffset;
    std::atomic<bool> useAggressive{false};
};

class PTSRewriter
{
public:
    PTSRewriter(flicks _frameDuration);
    ~PTSRewriter();

    int ScheduleFrame(float speed, flicks duration, int maxCount, std::function<void(flicks)> cb);

private:
    const flicks frameDuration;

    flicks lastOutputPTS{0};
    flicks lastAlignedOutputPTS{0};
};

class OffsetTracker
{
public:
    void SetDesiredDelay(flicks delay);
    void SetAdditionalDelay(flicks delay);
    void SetMinTotalDelay(flicks newMinTotalDelay);

    flicks GetTotalDelay() const;
    flicks GetIdealPlayheadTimestamp() const;

private:
    flicks desiredDelay{0};
    flicks additionalDelay{0};
    flicks minTotalDelay{toFlicks(std::chrono::seconds(MIN_DESIRED_DELAY))};
    const flicks maxTotalDelay{toFlicks(std::chrono::seconds(MAX_DESIRED_DELAY))};

    mutable std::mutex totalDelayMutex;
};

}  // namespace Vape
