#pragma once

#include "vapour-player-core/time.hpp"

#include <soundtouch/SoundTouch.h>

extern "C" {
#include <libavutil/frame.h>
}

#include <functional>
#include <memory>

namespace Vape {

class SoundTouchWrapper
{
public:
    SoundTouchWrapper(int _sampleRate, int _noChannels, int _channelLayout);
    ~SoundTouchWrapper();
    void SetTempo(float tempo);

    bool SendAVFrame(AVFrame *in);
    bool ReceiveAVFrame(AVFrame *out);
    void GetFrames(const AVRational &timeBase, std::function<bool(AVFrame *, flicks)> cb);
    flicks GetRewriteOffset() const;

private:
    soundtouch::SoundTouch st;

    int64_t inputPTS  = 0;
    int64_t outputPTS = 0;
    const int sampleRate;
    const int noChannels;
    const int channelLayout;
};

}  // namespace Vape
