#pragma once
#include <string>
#include <tuple>

namespace Vape {
struct ConsumerSettings {
    std::string displayModeString;
    std::string outputDeviceString;
    std::string placeholderTypeString;

    auto
    Tie() const
    {
        return std::tie(displayModeString, outputDeviceString, placeholderTypeString);
    }

    bool
    operator==(const ConsumerSettings &o) const
    {
        return this->Tie() == o.Tie();
    }

    bool
    operator!=(const ConsumerSettings &o) const
    {
        return this->Tie() != o.Tie();
    }
};
}  // namespace Vape
