#pragma once
#include <string>
#include <tuple>

namespace Vape {
struct DeckLinkSettings {
    int genlockOffset;
    bool sdi3GMode;

    auto
    Tie() const
    {
        return std::tie(genlockOffset, sdi3GMode);
    }

    bool
    operator==(const DeckLinkSettings &o) const
    {
        return this->Tie() == o.Tie();
    }

    bool
    operator!=(const DeckLinkSettings &o) const
    {
        return this->Tie() != o.Tie();
    }
};
}  // namespace Vape
