#pragma once
#include "vapour-player-core/time.hpp"
#include "vapour-player-core/types/transcode-limits.hpp"

#include <string>

constexpr auto DEFAULT_DESIRED_DELAY = std::chrono::seconds(10);

namespace Vape {
struct PlayerSettings {
    std::string streamName;
    flicks desiredDelay{DEFAULT_DESIRED_DELAY};
    bool enabled{false};
    PlayerCore::TranscodeLimits maxTranscode;

    auto
    Tie() const
    {
        return std::tie(streamName, desiredDelay, enabled, maxTranscode);
    };

    bool
    operator==(const PlayerSettings &o) const
    {
        return this->Tie() == o.Tie();
    }

    bool
    operator!=(const PlayerSettings &o) const
    {
        return this->Tie() != o.Tie();
    }
};
}  // namespace Vape
