#pragma once

#include "../stop-reason.hpp"
#include "../utils/queue-average.hpp"
#include "./multistream-audiolevels.hpp"
#include "./multistream-decklink.hpp"
#include "./multistream-playbackstatus.hpp"
#include "./multistream-systemstatus.hpp"
#include "./perfmon.hpp"
#include "fundamentals/signal-group.hpp"
#include "fundamentals/signal-listener.hpp"
#include "pubsub/topic-provider.hpp"
#include "vapour-player-core/listener.hpp"
#include "vapour-player-core/time.hpp"
#include "vapour-player-core/types/streamindex.hpp"

namespace Vape {
class LibAVDecoder;
class DeckLinkOutput;
class Player;

template <typename T>
class TopicGroup
{
    PubSub::TopicProvider<T> provider;
    T value;

    const system_clock::duration tick;

    system_clock::time_point lastUpdate;
    bool changed;

public:
    TopicGroup(PubSub::Client &client_, std::string topic_, std::optional<std::string> path_,
               system_clock::duration tick_);
    void Poll(system_clock::time_point tp);

    template <typename... Params>
    void Reset(const Params &...);

    template <typename Member, typename ValueType>
    void UpdateMember(Member T::*c, const ValueType &v);

    template <typename L>
    void Update(L l);

    const T &
    Value() const
    {
        return this->value;
    }
};

class StatusManager
{
public:
    StatusManager(PubSub::Client &pubsubClient);

    void SubscribeToTwitchStreamFetcher(Signal::ListenerPtrList &list, PlayerCore::Listener &);
    void SubscribeToDecoder(Signal::ListenerPtrList &list, LibAVDecoder &);
    void SubscribeToDeckLink(Signal::ListenerPtrList &list, DeckLinkOutput &);

    void Poll();
    void Reset(bool enabled);

    void HandleAudioLevels(const std::vector<float> &channels);
    void HandleTotalDelay(const flicks &delay);

private:
    const std::string h{"StatusManager"};

    Signal::Group signalGroup;

    template <typename L, typename... S>
    void Subscribe(Signal::ListenerPtrList &list, Signal::Provider<S...> &s, L l);

    TopicGroup<Topic::MultistreamDeckLink> deckLink;
    TopicGroup<Topic::MultistreamAudioLevels> audioLevels;
    TopicGroup<Topic::MultistreamPlaybackStatus> videoStatus;
    TopicGroup<Topic::MultistreamPlaybackStatus> audioStatus;
    TopicGroup<Topic::MultistreamSystemStatus> systemStatus;

    std::vector<QueueAverage<float, 60>> audioAvg;
    std::array<PerfMon, 2> perfMons;

    TopicGroup<Topic::MultistreamPlaybackStatus> &GetStreamStatus(StreamIndex index);
};

}  // namespace Vape
