#pragma once
#include "fundamentals/rapidjson-helpers.hpp"
#include "vapour-player-core/time.hpp"

#include <pajlada/serialize/serialize.hpp>

#include <array>
#include <string>
#include <tuple>

namespace Vape::Topic {
/**
 * The topic for DeckLink status reporting
 */
struct MultistreamAudioLevels {
    struct Level {
        float avg;
        float peak;
        std::string channel;
        int stream;

        bool
        operator==(const Level &o) const
        {
            return avg == o.avg && peak == o.peak && channel == o.channel && stream == o.stream;
        }
    };

    std::vector<Level> levels;

    static constexpr const char *topicString{"MultistreamAudioLevels"};

    auto
    Tie() const
    {
        return std::tie(levels);
    }

    bool Update(system_clock::time_point)
    {
        return false;
    }

    bool
    operator==(const MultistreamAudioLevels &o) const
    {
        return this->Tie() == o.Tie();
    }

    bool
    operator!=(const MultistreamAudioLevels &o) const
    {
        return this->Tie() != o.Tie();
    }

    bool
    Reset()
    {
        bool changed = !this->levels.empty();
        this->levels.clear();
        return changed;
    }
};

}  // namespace Vape::Topic

namespace pajlada {
template <typename RJValue>
struct Serialize<Vape::Topic::MultistreamAudioLevels::Level, RJValue> {
    static RJValue
    get(const Vape::Topic::MultistreamAudioLevels::Level &in, typename RJValue::AllocatorType &a)
    {
        RJValue out(rapidjson::kObjectType);

        Vape::rj::Set(out, "Avg", in.avg, a);
        Vape::rj::Set(out, "Peak", in.peak, a);
        Vape::rj::Set(out, "Channel", in.channel, a);
        Vape::rj::Set(out, "Stream", in.stream, a);

        return out;
    }
};

template <typename RJValue>
struct Serialize<Vape::Topic::MultistreamAudioLevels, RJValue> {
    static RJValue
    get(const Vape::Topic::MultistreamAudioLevels &in, typename RJValue::AllocatorType &a)
    {
        RJValue out(rapidjson::kObjectType);

        Vape::rj::Set(out, "Levels", in.levels, a);

        return out;
    }
};
}  // namespace pajlada
