#pragma once
#include "../consumer/decklink-genlock-status.hpp"
#include "fundamentals/helpers.hpp"
#include "fundamentals/rapidjson-helpers.hpp"
#include "vapour-player-core/time.hpp"

#include <pajlada/serialize/serialize.hpp>

#include <tuple>

namespace Vape::Topic {
/**
 * The topic for DeckLink status reporting
 */
struct MultistreamDeckLink {
    DeckLinkGenlockStatus genlockStatus{DeckLinkGenlockStatus::NotSupported};

    static constexpr const char *topicString{"MultistreamDeckLink"};

    auto
    Tie() const
    {
        return std::tie(genlockStatus);
    }

    bool Update(system_clock::time_point)
    {
        return false;
    }

    bool
    operator==(const MultistreamDeckLink &o) const
    {
        return this->Tie() == o.Tie();
    }

    bool
    operator!=(const MultistreamDeckLink &o) const
    {
        return this->Tie() != o.Tie();
    }
};

}  // namespace Vape::Topic

namespace pajlada {
template <typename RJValue>
struct Serialize<Vape::Topic::MultistreamDeckLink, RJValue> {
    static RJValue
    get(const Vape::Topic::MultistreamDeckLink &in, typename RJValue::AllocatorType &a)
    {
        RJValue out(rapidjson::kObjectType);

        Vape::rj::Set(out, "GenlockStatus", fS("{}", in.genlockStatus), a);

        return out;
    }
};
}  // namespace pajlada
