#pragma once
#include "./multistream-playbackstatus-group.hpp"
#include "./statusindicator.hpp"
#include "debug/log.hpp"
#include "fundamentals/helpers.hpp"
#include "fundamentals/rapidjson-helpers.hpp"
#include "vapour-player-core/time.hpp"
#include "vapour-player-core/types/streamstatus.hpp"
#include "vapour-player-core/types/streamtype.hpp"

#include <pajlada/serialize/serialize.hpp>

#include <ctime>
#include <tuple>

namespace Vape::Topic {
static const std::string h{"Topic:MultistreamSystemStatus"};

/**
 * The topic for DeckLink status reporting
 */
struct MultistreamSystemStatus {
    static constexpr const char *topicString{"MultistreamSystemStatus"};

    float minTotalDelay{0};
    float activeTotalDelay{0};
    bool ptsSearchDone{false};
    bool playbackStarted{false};
    bool timeBaseCorrected{false};
    StreamStatus streamStatus{StreamStatus::Disabled};
    StreamType streamType{StreamType::Disabled};
    std::string activeTranscode;
    bool activeTranscodeIsSource{false};
    bool readyForLive{false};

    auto
    Tie() const
    {
        return std::tie(minTotalDelay, activeTotalDelay, ptsSearchDone, playbackStarted,
                        timeBaseCorrected, streamStatus, streamType, activeTranscode,
                        activeTranscodeIsSource, readyForLive);
    }

    bool
    operator!=(const MultistreamSystemStatus &o)
    {
        return this->Tie() != o.Tie();
    }

    bool
    Reset(bool enabled)
    {
        MultistreamSystemStatus test;

        if (enabled) {
            test.streamStatus = StreamStatus::Offline;
            test.streamType   = StreamType::Disabled;
        }

        if (*this != test) {
            *this = test;
            return true;
        }

        return false;
    }

    bool Update(system_clock::time_point)
    {
        return false;
    }
};

}  // namespace Vape::Topic

namespace pajlada {
template <typename RJValue>
struct Serialize<Vape::Topic::MultistreamSystemStatus, RJValue> {
    static RJValue
    get(const Vape::Topic::MultistreamSystemStatus &in, typename RJValue::AllocatorType &a)
    {
        RJValue out(rapidjson::kObjectType);

        Vape::rj::Set(out, "MinTotalDelay", in.minTotalDelay, a);
        Vape::rj::Set(out, "ActiveTotalDelay", in.activeTotalDelay, a);
        Vape::rj::Set(out, "PTSSearchDone", in.ptsSearchDone, a);
        Vape::rj::Set(out, "PlaybackStarted", in.playbackStarted, a);
        Vape::rj::Set(out, "TimeBaseCorrected", in.timeBaseCorrected, a);
        Vape::rj::Set(out, "StreamStatus", fS("{}", in.streamStatus), a);
        Vape::rj::Set(out, "StreamType", fS("{}", in.streamType), a);
        Vape::rj::Set(out, "ActiveTranscode", in.activeTranscode, a);
        Vape::rj::Set(out, "ActiveTranscodeIsSource", in.activeTranscodeIsSource, a);
        Vape::rj::Set(out, "ReadyForLive", in.readyForLive, a);

        // auto t = system_clock::to_time_t(system_clock::now());
        // Vape::rj::Set(out, "SystemTime", Vape::fS("{}", std::ctime(&t)), a);

        return out;
    }
};
}  // namespace pajlada
