#include "./perfmon.hpp"

#include <limits>

namespace Vape {
PerfMon::PerfMon()
    : buffer(50)
{
}

void
PerfMon::Push(const Record &record)
{
    this->buffer.push_back(record);
}

void
PerfMon::Reset()
{
    this->buffer.clear();
}

float
PerfMon::GetCPUSaturation()
{
    if (this->buffer.size() < 2) {
        return 0;
    }

    auto span = this->buffer.back().time - this->buffer.front().time;
    steady_clock::duration timeUsed{0};

    for (auto it = this->buffer.begin(); it != this->buffer.end() - 1; ++it) {
        timeUsed += it->dur;
    }

    float fTimeUsed = toFloat(timeUsed);
    float fSpan     = toFloat(span);
    float epsilon   = std::numeric_limits<float>::epsilon();

    if (fTimeUsed < epsilon || fSpan < epsilon) {
        return 0;
    }

    return fTimeUsed / fSpan;
}

}  // namespace Vape
