#pragma once
#include "vapour-player-core/time.hpp"

#include <boost/circular_buffer.hpp>

namespace Vape {
class PerfMon
{
public:
    struct Record {
        steady_clock::time_point time;
        steady_clock::duration dur;
    };

    PerfMon();

    void Push(const Record &record);
    void Reset();
    float GetCPUSaturation();

private:
    boost::circular_buffer<Record> buffer;
};
}  // namespace Vape
