#pragma once

#include <ostream>

namespace Vape {

enum class StopReason {
    Running,          // Player thread is currently running
    WaitingForStart,  // Return value has been handled, waiting for throttler

    None,
    InvalidOutputType,
    StreamError,
    StreamEnded,
    DecoderError,
    PlayerCoreSampleReceivedBeforeConfigure,
    ConsumerError,
    ConsumerNotReady,
    ConsumerStoppedPlayback,
    SampleStreamStopped,
    WaitingForAuthenticator,
    SettingsChanged,
    StreamNameEmpty,
    OutputNotEnabled,
    Uncategorized,
};

inline std::ostream &
operator<<(std::ostream &os, StopReason v)
{
    switch (v) {
        case StopReason::Running:
            return os << "Running";
        case StopReason::WaitingForStart:
            return os << "WaitingForStart";

        case StopReason::None:
            return os << "None";
        case StopReason::InvalidOutputType:
            return os << "InvalidOutputType";
        case StopReason::StreamError:
            return os << "StreamError";
        case StopReason::StreamEnded:
            return os << "StreamEnded";
        case StopReason::DecoderError:
            return os << "DecoderError";
        case StopReason::PlayerCoreSampleReceivedBeforeConfigure:
            return os << "PlayerCoreSampleReceivedBeforeConfigure";
        case StopReason::ConsumerError:
            return os << "ConsumerError";
        case StopReason::ConsumerNotReady:
            return os << "ConsumerNotReady";
        case StopReason::ConsumerStoppedPlayback:
            return os << "ConsumerStoppedPlayback";
        case StopReason::SampleStreamStopped:
            return os << "SampleStreamStopped";
        case StopReason::WaitingForAuthenticator:
            return os << "WaitingForAuthenticator";
        case StopReason::SettingsChanged:
            return os << "SettingsChanged";
        case StopReason::StreamNameEmpty:
            return os << "StreamNameEmpty";
        case StopReason::OutputNotEnabled:
            return os << "OutputNotEnabled";
        case StopReason::Uncategorized:
            return os << "Uncategorized";
        default:
            return os << "InternalError:" << static_cast<int>(v);
    }
}

}  // namespace Vape
