#pragma once
#include <boost/circular_buffer.hpp>

#include <numeric>

namespace Vape {
template <typename T, size_t L>
class QueueAverage
{
public:
    QueueAverage()
        : buffer(L)
    {
    }

    void
    Push(const T &t)
    {
        this->buffer.push_back(t);
    }

    void
    Reset()
    {
        this->buffer.clear();
    }

    T
    Average() const
    {
        if (this->buffer.empty()) {
            return T();
        }

        auto acc = std::accumulate(this->buffer.begin(), this->buffer.end(), T());
        return acc / this->buffer.size();
    }

    T
    Min() const
    {
        if (this->buffer.empty()) {
            return T();
        }

        auto it = std::min_element(this->buffer.begin(), this->buffer.end());
        return *it;
    }

    T
    Max() const
    {
        if (this->buffer.empty()) {
            return T();
        }

        auto it = std::max_element(this->buffer.begin(), this->buffer.end());
        return *it;
    }

private:
    boost::circular_buffer<T> buffer;
};
}  // namespace Vape
