#include "./thread-affinity.hpp"

#include "../config.hpp"
#include "debug/log.hpp"
#include "thread-helpers/thread-helpers.hpp"

namespace Vape {

const std::string h{"ThreadAffinity"};

void
SetThreadNameAndAffinity(const std::string &name)
{
    RenameThread(name);
    Log::TTrace(h, "Setting thread name to: {}", name);

    // Update thread affinity if specified from an environment variable
    const auto &conf = Config::Get();
    if (conf.threadAffinity >= 0) {
        Log::TDebug(h, "Setting thread affinity: {}", conf.threadAffinity);
        int res = Thread::SetAffinity(Thread::CurrentHandle(), conf.threadAffinity);
        if (res != 0) {
            Log::TError(h, "Error calling Thread::SetAffinity: {}", res);
        }
    } else {
        Log::TTrace(h, "No thread affinity configured");
    }
}

}  // namespace Vape
