#!/bin/sh

# utils/package.sh can be created to be called from this script

versions=$(git for-each-ref --format='%(refname:short)' refs/remotes/origin --contains)

script_path=$(CDPATH='' cd -- "$(dirname -- "$0")" && pwd)
. "$script_path/config.sh"

working_dir=".deploy"
deploy_folder="symbol-deploy"

for version in $versions; do
    version=$(echo "$version" | sed 's/^origin\///' | tr '[:upper:]' '[:lower:]')
    if [ "$(echo "$version" | cut -d'/' -f1)" = "release" ]; then
        version="v$(echo "$version" | cut -d'/' -f2)"
        deploy_s3_bucket="vapour.prod.symbols"
    else
        version=$(echo "$version" | sed 's/\//-/g')
        deploy_s3_bucket="vapour.dev.symbols"
    fi
    echo "$version - $deploy_s3_bucket"

    package_name="$version.tgz"
    s3_path="s3://$deploy_s3_bucket/$appname/$package_name"
    local_path="$working_dir/$package_name"

    rm -rf "$working_dir"
    mkdir -p "$working_dir"

    echo "Deploying '$local_path' to '$s3_path'"

    ./utils/safe-exec.sh package.sh

    # Do your packaging step here
    if ! tar czf "$local_path" -C "$deploy_folder" .; then
        exit 1
    fi

    # Upload version
    aws s3 cp "$local_path" "$s3_path"
done
