#!/bin/sh

set -e

script_path=$(CDPATH='' cd -- "$(dirname -- "$0")" && pwd)
. "$script_path/../config.sh"

tag="boost1.73.0"

for dockerfile in .docker/Dockerfile.*; do
    dockerfile_type=$(echo "$dockerfile" |awk -F . '{if (NF>1) {print $NF}}')
    if [ -z "$dockerfile_type" ]; then
        echo " ! Not a valid dockerfile name: $dockerfile"
        continue
    fi
    echo " * Pushing docker image for $dockerfile_type"
    docker tag vapour/"$appname"-"$dockerfile_type" docker.pkgs.xarth.tv/vapour/"$appname"-"$dockerfile_type":"$tag"
    docker push docker.pkgs.xarth.tv/vapour/"$appname"-"$dockerfile_type":"$tag"
done
