#!/bin/sh

set -eu

ndi_sdk_path="$PWD/3rdParty/ndi-sdk"
ndi_sdk_url="http://514f211588de67e4fdcf-437b8dd50f60b69cf0974b538e50585b.r63.cf1.rackcdn.com/Utilities/SDK/NDI_SDK_Linux_v2/InstallNDISDK_v4_Linux.tar.gz"
ndi_sdk_version="2020-03-23 @ r112958"

if [ -f "$ndi_sdk_path/Version.txt" ]; then
    installed_version=$(cat "$ndi_sdk_path/Version.txt")
    if [ "$installed_version" = "$ndi_sdk_version" ]; then
        echo "NDI SDK already installed and up-to-date. Want to force a reinstall? rm -rf $ndi_sdk_path"
        exit 0
    fi

    echo "Installed version ($installed_version) does not match new version ($ndi_sdk_version), time to do a reinstall."
fi

# Create temporary folder where we download the SDK files and unzip them
cd "$(mktemp -d)" || exit 1

echo "Downloading NDI SDK..."

wget -O ndi-sdk.tar.gz "$ndi_sdk_url"

echo "Extracting NDI SDK..."
tar xzf ndi-sdk.tar.gz

mv ./*.sh install-ndi-sdk.sh

target_line="$(sed -n '/^__NDI_ARCHIVE_BEGIN__$/=' install-ndi-sdk.sh)"
target_line="$((target_line + 1))"

tail -n +"$target_line" install-ndi-sdk.sh | tar -zxf -

echo "Installing NDI SDK... ($(cat 'NDI SDK for Linux/Version.txt'))"

# Remove any potentially existing ndi sdk installation
rm -rf "$ndi_sdk_path"

mv 'NDI SDK for Linux' "$ndi_sdk_path"

ls -1 "$ndi_sdk_path/lib/x86_64-linux-gnu/"*.so*

echo "Done!"
