module.exports = {
  env: {
    node: true,
    es6: true,
  },
  parser: '@typescript-eslint/parser',
  parserOptions: {
    sourceType: 'module',
    project: './tsconfig.json',
  },
  extends: [
    /* Base ESLint Config */
    'eslint:recommended',

    /* TypeScript ESLint */
    'plugin:@typescript-eslint/recommended',
    'plugin:@typescript-eslint/eslint-recommended',
    'plugin:@typescript-eslint/recommended-requiring-type-checking',

    /* Import */
    'plugin:import/errors',
    'plugin:import/warnings',
    'plugin:import/typescript',
  ],
  plugins: ['simple-import-sort', 'sort-keys-fix', '@typescript-eslint', 'import'],
  rules: {
    /* Object Formatting */
    'object-shorthand': [
      'warn',
      'always',
      {
        avoidQuotes: true,
      },
    ],

    /* Sort Object keys */
    'sort-keys': [
      'warn',
      'asc',
      {
        caseSensitive: true,
        natural: false,
        minKeys: 2,
      },
    ],
    'sort-keys-fix/sort-keys-fix': 'warn',

    /* Sorting */
    'simple-import-sort/sort': 'warn',

    /* Handled by Prettier */
    /* Enforce consistent spacing before function definition opening parenthesis */
    '@typescript-eslint/space-before-function-paren': 'off',
    /* Enforce camelCase naming convention */
    '@typescript-eslint/camelcase': 'off',
    /* Enforce the consistent use of either backticks, double, or single quotes */
    '@typescript-eslint/quotes': 'off',
    /* Require or disallow semicolons instead of ASI */
    '@typescript-eslint/semi': 'off',
    /* Enforce consistent indentation */
    '@typescript-eslint/indent': 'off',
    /* Disallow unnecessary parentheses */
    '@typescript-eslint/no-extra-parens': 'off',

    /* Disabled */
    /* Disallow the use of parameter properties in class constructors */
    '@typescript-eslint/no-parameter-properties': 'off',
    /* Enforce template literal expressions to be of string type */
    '@typescript-eslint/restrict-template-expressions': 'off',
    /* Requires type annotations to exist */
    '@typescript-eslint/typedef': 'off',
    /* Disallows magic numbers */
    '@typescript-eslint/no-magic-numbers': 'off',
    /* Requires Promise-like values to be handled appropriately. */
    '@typescript-eslint/no-floating-promises': 'off',
    /* Disallow the use of type aliases */
    '@typescript-eslint/no-type-alias': 'off',
    /* Disallows non-null assertions using the ! postfix operator */
    '@typescript-eslint/no-non-null-assertion': 'off',
    /* Restricts the types allowed in boolean expressions */
    '@typescript-eslint/strict-boolean-expressions': 'off',
    /* Disallow the use of custom TypeScript modules and namespaces */
    '@typescript-eslint/no-namespace': 'off',
    ///* Avoid using promises in places not designed to handle them */
    '@typescript-eslint/no-misused-promises': 'off',
    /* Prevents conditionals where the type is always truthy or always falsy */
    '@typescript-eslint/no-unnecessary-condition': 'off',
    /* Enforces naming of generic type variables */
    '@typescript-eslint/generic-type-naming': 'off',
    /* Require that interface names should or should not prefixed with I */
    '@typescript-eslint/interface-name-prefix': 'off',
    /* Require explicit return types on functions and class methods */
    '@typescript-eslint/explicit-function-return-type': 'off',
    /* Disallows invocation of require() */
    '@typescript-eslint/no-require-imports': 'off',
    /* Sets preference level for triple slash directives versus ES6-style import declarations */
    '@typescript-eslint/triple-slash-reference': 'off',

    /* Enabled */
    /* Requires using either T[] or Array<T> for arrays */
    '@typescript-eslint/array-type': 'warn',
    /* Bans “// @ts-ignore” comments from being used */
    '@typescript-eslint/ban-ts-comment': 'warn',
    /* Bans specific types from being used */
    '@typescript-eslint/ban-types': [
      'warn',
      {
        extendDefaults: false,
        types: {
          /* typos */
          String: {
            message: 'Use string instead',
            fixWith: 'string',
          },
          Boolean: {
            message: 'Use boolean instead',
            fixWith: 'boolean',
          },
          Number: {
            message: 'Use number instead',
            fixWith: 'number',
          },
          Symbol: {
            message: 'Use symbol instead',
            fixWith: 'symbol',
          },
          Object: {
            message: [
              'The `Object` type actually means "any non-nullish value", so it is marginally better than `unknown`.',
              '- If you want a type meaning "any object", you probably want `Record<string, unknown>` instead.',
              '- If you want a type meaning "any value", you probably want `unknown` instead.',
            ].join('\n'),
          },
        },
      },
    ],
    /* Enforce consistent brace style for blocks */
    '@typescript-eslint/brace-style': 'warn',
    /* Consistent with type definition either interface or type */
    '@typescript-eslint/consistent-type-definitions': 'warn',
    /* Require explicit accessibility modifiers on class properties and methods */
    '@typescript-eslint/explicit-member-accessibility': 'warn',
    /* Require or disallow spacing between function identifiers and their invocations */
    '@typescript-eslint/func-call-spacing': 'warn',
    /* Require a consistent member declaration order */
    '@typescript-eslint/member-ordering': 'warn',
    /* Bans usage of the delete operator with computed key expressions */
    '@typescript-eslint/no-dynamic-delete': 'warn',
    /* Disallow usage of the any type */
    '@typescript-eslint/no-explicit-any': 'warn',
    /* Disallow extra non-null assertion */
    '@typescript-eslint/no-extra-non-null-assertion': 'warn',
    /* Forbids the use of classes as namespaces */
    '@typescript-eslint/no-extraneous-class': 'off',
    /* Disallow aliasing this */
    '@typescript-eslint/no-this-alias': 'warn',
    /* Requires that all public method arguments and return type will be explicitly typed */
    '@typescript-eslint/explicit-module-boundary-types': 'warn',
    /* Disallow unused expressions */
    '@typescript-eslint/no-unused-expressions': 'warn',
    /* Disallow unused variables */
    '@typescript-eslint/no-unused-vars': 'warn',
    /* Disallow unnecessary constructors */
    '@typescript-eslint/no-useless-constructor': 'warn',
    /* Disallows the use of require statements except in import statements */
    '@typescript-eslint/no-var-requires': 'warn',
    /* Prefer a ‘for-of’ loop over a standard ‘for’ loop if the index is only used to access the array being iterated */
    '@typescript-eslint/prefer-for-of': 'warn',
    /* Use function types instead of interfaces with call signatures */
    '@typescript-eslint/prefer-function-type': 'warn',
    /* Prefer using concise optional chain expressions instead of chained logical ands */
    '@typescript-eslint/prefer-optional-chain': 'warn',
    /* Warns for any two overloads that could be unified into one by using a union or an optional/rest parameter */
    '@typescript-eslint/unified-signatures': 'warn',
  },
  globals: {
    Atomics: 'readonly',
    SharedArrayBuffer: 'readonly',
  },
  overrides: [
    {
      files: '*.spec.ts',
      env: {
        mocha: true,
      },
      plugins: ['mocha'],
      extends: ['plugin:mocha/recommended'],
      rules: {
        /* stops strict enforcement of context driven test function runners */
        'mocha/no-mocha-arrows': 'off',

        /* allows chai syntax something.should.be.undefined */
        '@typescript-eslint/no-unused-expressions': 'off',

        /* triggers when calling expect on a method */
        '@typescript-eslint/unbound-method': 'off',
      },
    },
  ],
};
