# osc-service

Microservice to update settings via OSC commands

- [Twitch Wiki Entry](https://wiki.twitch.com/display/ESP/osc-service)

- [Changelog](CHANGELOG.md)

## Development

To run this service locally - first ensure you have Vapour Core setup.

Next, clone this repository:

```bash
git clone git@git-aws.internal.justin.tv:vapour/osc-service.git
```

You will next need to populate an environment file `.env` - this is used to emulate Supervisor.

```
# Make the file
touch .env

# Write
cat <<EOT >> .env
NODE_ENV=development # enables debug logging
VAPOUR_CORE_HOST=<Vapour Core (if running locally, this should be 192.168.0.X most likely)>
VAPOUR_OSCSERVICE_HOST=0.0.0.0
VAPOUR_OSCSERVICE_PORT=3333
EOT
```

## Deploying to Staging/Production

### Staging

You can run this service on a Vapour staging server by using the `vapour-updater` binary.

```bash
vapour-updater --buckets vapour.dev select osc-service master
```

### Production

To run this on a production server, it is highly recommended to explicitly version services instead of tracking master.

**You may also need to upgrade supervisor if this is the first deploy of this service to the Vapour server.**

```bash
# List versions available
vapour-updater check osc-service

vapour-updater select osc-service <version wanted>

## Tests

To run the test suite, first install the dependencies, then run `npm test`:

```bash
$ NODE_ENV=development npm install
$ npm test
```
