job {
    name 'vapour-osc-service'
    using 'TEMPLATE-autobuild'
    wrappers {
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'vapour-aws-s3-test-config')
            file('AWS_SHARED_CREDENTIALS_FILE', 'vapour-aws-s3-test-credentials')
        }
        environmentVariables {
            env('AWS_DEFAULT_PROFILE', 'vapour-pajlada-test')
        }
    }
    scm {
        git {
            remote {
                github 'vapour/osc-service', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
        }
    }

    steps {
        shell './utils/safe-exec.sh presetup.sh'
        shell './utils/setup.sh'
        shell './utils/safe-exec.sh postsetup.sh'

        shell './utils/manta.sh'

        shell './utils/safe-exec.sh predeploy.sh'
        shell './utils/deploy.sh'
        shell './utils/safe-exec.sh postdeploy.sh'
    }
}
