/// <reference types="node" />

declare module 'osc-min' {
  export interface OSCValue {
    type: 'float' | 'integer' | 'string';
  }

  export interface OSCFloatValue extends OSCValue {
    type: 'float';
    value: number;
  }

  export interface OSCIntegerValue extends OSCValue {
    type: 'integer';
    value: number;
  }

  export interface OSCStringValue extends OSCValue {
    type: 'string';
    value: string;
  }

  export interface OSCBaseMessage {
    oscType: 'message' | 'bundle';
  }

  export interface OSCMessage extends OSCBaseMessage {
    address: string;
    args: OSCValue[];
    oscType: 'message';
  }

  export interface OSCBundle extends OSCBaseMessage {
    elements: OSCBaseMessage[];
    oscType: 'bundle';
  }

  export function fromBuffer(buffer: Buffer): OSCBaseMessage;
}
