import gql from 'graphql-tag';

export const GetActiveEventVapour = gql`
  query GetActiveEventVapour($channelId: ID!){
    channel(channelId: $channelId) {
      currentEvent {
        eventId,
        participants {
          participantId,
          meta,
          metaVapour
        }
      }
    }
  }
`;

export const UpdateEventParticipantsVapour = gql`
  mutation UpdateEventParticipantsVapour(
          $eventId: ID!
          $channelId: ID!
          $participants: [ParticipantInput!]!
        ) {
    updateEventParticipants(
      eventId: $eventId
      channelId: $channelId
      participants: $participants
    ) {
      eventId
      gameName
      eventName
      meta
      participants {
        participantId
        meta
        metaVapour
      }
    }
  }
`;

export interface ParticipantInput {
  participantId: string;
  metaVapour: {
    teamRank?: number,
    moneyTotal?: string,
  };
}
