#!/bin/sh

# utils/package.sh can be created to be called from this script

versions=$(git for-each-ref --format='%(refname:short)' refs/remotes/origin --contains)

script_path=$(CDPATH='' cd -- "$(dirname -- "$0")" && pwd)
. "$script_path/config.sh"

for version in $versions; do
    version=$(echo "$version" | sed 's/^origin\///')
    if [ "$(echo "$version" | cut -d'/' -f1)" = "release" ]; then
        version="v$(echo "$version" | cut -d'/' -f2)"
        deploy_s3_bucket="pajlada.test"
    else
        deploy_s3_bucket="vapour.dev"
    fi
    echo "$version - $deploy_s3_bucket"

    package_name="$version.tgz"
    s3_path="s3://$deploy_s3_bucket/$appname/$package_name"
    local_path=".deploy/$package_name"

    rm -rf .deploy
    mkdir -p .deploy

    echo "Deploying '$local_path' to '$s3_path'"

    echo "vapour-updater --buckets '$deploy_s3_bucket' download $appname $version"
    echo "^ This downloads the version to be selected later in the control panel"

    echo "vapour-updater --buckets '$deploy_s3_bucket' select $appname $version"
    echo "^ This downloads and installs the version to be used right now"

    ./utils/safe-exec.sh package.sh

    # Do your packaging step here
    if ! tar czf "$local_path" -C deploy .; then
        exit 1
    fi

    # Upload version
    aws s3 cp "$local_path" "$s3_path"
done
