#pragma once

#include <string>
#include <thread>

#ifdef _WIN32
#include <windows.h>
#endif

#ifdef __linux__
#include <pthread.h>
#endif

namespace Vape {

namespace Thread {

inline auto
CurrentHandle()
{
#ifdef __linux__
    return pthread_self();
#elif defined(_WIN32)
    return ::GetCurrentThread();
#else
    // unimplemented platform stuff
    assert(false);
    return -1;
#endif
}

int SetAffinity(std::thread::native_handle_type nativeHandle, int index);
int GetAffinity(std::thread::native_handle_type nativeHandle, cpu_set_t &cpuset);

}  // namespace Thread

void RenameThread(std::string threadName);

}  // namespace Vape
