#include <gtest/gtest.h>

#include "thread-helpers/thread-helpers.hpp"

#ifdef __linux__
#include <pthread.h>
#include <sys/prctl.h>
#endif

TEST(SetAffinity, ShouldNotFail)
{
    using namespace Vape;

    EXPECT_EQ(Thread::SetAffinity(Thread::CurrentHandle(), 1), 0);
}

TEST(SetAffinity, VerifyHasBeenSet)
{
    using namespace Vape;

    EXPECT_EQ(Thread::SetAffinity(Thread::CurrentHandle(), 1), 0);

    cpu_set_t index;

    auto res = Thread::GetAffinity(Thread::CurrentHandle(), index);

    cpu_set_t expected;
    CPU_ZERO(&expected);
    CPU_SET(1, &expected);

    EXPECT_EQ(res, 0);
    EXPECT_TRUE(CPU_EQUAL(&index, &expected));
}

int
main(int argc, char **argv)
{
    ::testing::InitGoogleTest(&argc, argv);

    return RUN_ALL_TESTS();
}
