#!/bin/sh

script_path=$(CDPATH='' cd -- "$(dirname -- "$0")" && pwd)
. "$script_path/../config.sh"

git_release="$(git describe 2>/dev/null)"
if [ ! $! ]; then
    git_release="dev"
fi

if [ -z "$run_args" ]; then
    run_args=""
fi

if [ -z "$EXTRA_RUN_ARGS" ]; then
    EXTRA_RUN_ARGS=""
fi

if [ -z "$run_cmd" ]; then
    run_cmd="/docker-run/$appname"
fi

docker run \
    --name "$appname" \
    $run_args \
    $EXTRA_RUN_ARGS \
    --rm \
    -e GIT_BRANCH="$(git rev-parse --abbrev-ref HEAD)" \
    -e GIT_COMMIT="$(git rev-parse HEAD)" \
    -e GIT_RELEASE="$git_release" \
    --mount type=bind,source=$PWD/build-docker-release,destination=/docker-run \
    vapour/"$appname"-run \
    "$run_cmd"
