#!/bin/sh

if [ -z "$GIT_BRANCH" ]; then
    GIT_BRANCH="$(git rev-parse --abbrev-ref HEAD 2>/dev/null)"
    export GIT_BRANCH
fi

if [ -z "$GIT_COMMIT" ]; then
    GIT_COMMIT="$(git rev-parse HEAD 2>/dev/null)"
    export GIT_COMMIT
fi

if [ -z "$GIT_RELEASE" ]; then
    if ! GIT_RELEASE="$(git describe 2>/dev/null)"; then
        GIT_RELEASE="dev"
    fi
    export GIT_RELEASE
fi

printf "Git branch='%s', commit='%s', release='%s'\n" "$GIT_BRANCH" "$GIT_COMMIT" "$GIT_RELEASE"

rm -rf build*
manta -v -proxy -E GIT_BRANCH -E GIT_COMMIT -E GIT_RELEASE
