#!/bin/sh

utils_dir=$(CDPATH='' cd -- "$(dirname -- "$0")" && pwd)

temp=$(getopt -o : -l recursive,base-dir: -- "$@")
eval set -- "$temp"

recursive="0"
base_dir="$utils_dir/.."

while true; do
    case "$1" in
        --recursive ) recursive="1"; shift ;;
        --base-dir ) base_dir="$2"; shift 2 ;;
        -- ) shift; break ;;
        * ) break ;;
    esac
done

printf "%sBase dir %s\n" "$indent_level" "$base_dir"

for path in "$base_dir/internal/"*; do
    [ ! -d "$path" ] && continue
    printf "%sFound %s\n" "$indent_level" "$path"
    if [ "$FORCE" != "1" ]; then
        if ! ( cd "$path" && git diff-index --quiet HEAD --); then
            printf "%s\033[31mWARNING\033[0m - LOCAL CHANGES DETECTED\n" "$indent_level"
            printf "%sCommit or discard the local changes in %s before proceeding\n" "$indent_level" "$PWD"
            printf "%sIf you believe this is wrong, set the environment variable FORCE to 1 (only if you know you have no uncommitted changes)\n" "$indent_level"
            exit 1
        fi
    fi
    ( cd "$path" && ( [ "$(git symbolic-ref --short HEAD)" = "master" ] || git checkout master --quiet) && git fetch && git merge && git submodule update --init --recursive )
    if [ "$recursive" = "1" ]; then
        old_indent_level="$indent_level"
        export indent_level="$indent_level  "
        $0 --base-dir="$path" --recursive
        export indent_level="$old_indent_level"
    fi
done
