module.exports = {
  root: true,
  plugins: [
    'filenames',
    'eslint-comments',
    'import',
    'simple-import-sort',
    'sort-keys-fix',
    '@typescript-eslint',
    'prettier',
  ],
  env: {
    es2020: true,
    node: true,
  },
  globals: {
    Atomics: 'readonly',
    SharedArrayBuffer: 'readonly',
  },
  extends: [
    /* ESLint */
    'eslint:recommended',

    /* Regex Optimisation */
    'plugin:optimize-regex/all',

    /* TypeScript */
    'plugin:@typescript-eslint/eslint-recommended',
    'plugin:@typescript-eslint/recommended',
    'plugin:@typescript-eslint/recommended-requiring-type-checking',

    /* Import */
    'plugin:import/errors',
    'plugin:import/warnings',
    'plugin:import/typescript',

    /* Prettier - MUST BE LAST */
    'prettier',
    'prettier/@typescript-eslint',
  ],
  parser: '@typescript-eslint/parser',
  parserOptions: {
    sourceType: 'module',
    project: ['./tsconfig.eslint.json', './tsconfig.json'],
    tsconfigRootDir: __dirname,
    warnOnUnsupportedTypeScriptVersion: false,
  },
  rules: {
    /* ESLint */
    curly: ['error', 'multi-line'],
    'no-useless-escape': 'warn',
    'no-mixed-operators': [
      'error',
      {
        groups: [
          ['&', '|', '^', '~', '<<', '>>', '>>>'],
          ['==', '!=', '===', '!==', '>', '>=', '<', '<='],
          ['&&', '||'],
          ['in', 'instanceof'],
        ],
        allowSamePrecedence: true,
      },
    ],

    /* File Names */
    'filenames/match-regex': ['warn', '^\\.?([a-z0-9]+[.\\-]?)+$', true],

    /* ESLint Comments */
    'eslint-comments/disable-enable-pair': ['warn', { allowWholeFile: true }],
    'eslint-comments/no-aggregating-enable': 'warn',
    'eslint-comments/no-duplicate-disable': 'warn',
    'eslint-comments/no-unlimited-disable': 'warn',
    'eslint-comments/no-unused-disable': 'warn',
    'eslint-comments/no-unused-enable': 'warn',
    'eslint-comments/no-use': [
      'warn',
      {
        allow: [
          'eslint-disable',
          'eslint-disable-line',
          'eslint-disable-next-line',
          'eslint-enable',
        ],
      },
    ],

    /* Imports */
    'import/named': 'off',
    'import/namespace': 'off',
    'import/default': 'off',
    'import/no-named-as-default-member': 'off',
    'import/no-unresolved': 'warn',
    'import/first': 'warn',
    'import/newline-after-import': 'error',
    'import/no-absolute-path': 'error',
    'import/no-amd': 'error',
    'import/no-default-export': 'warn',
    'import/no-extraneous-dependencies': [
      'error',
      {
        devDependencies: true,
        peerDependencies: true,
        optionalDependencies: false,
      },
    ],
    'import/no-mutable-exports': 'error',
    'import/no-named-default': 'error',
    'import/no-named-export': 'off',
    'import/no-self-import': 'error',
    'import/prefer-default-export': 'off',

    /* Object Formatting */
    'object-shorthand': [
      'warn',
      'always',
      {
        avoidQuotes: true,
      },
    ],

    /* Sort Object keys */
    'sort-keys': [
      'warn',
      'asc',
      {
        caseSensitive: true,
        natural: false,
        minKeys: 2,
      },
    ],
    'sort-keys-fix/sort-keys-fix': 'warn',

    /* Prettier */
    'prettier/prettier': 'warn',

    /* Sorting */
    'simple-import-sort/imports': 'warn',
    'simple-import-sort/exports': 'warn',

    /* TypeScript */
    /* Handled by Prettier */
    /* Enforce consistent spacing before function definition opening parenthesis */
    '@typescript-eslint/space-before-function-paren': 'off',
    /* Enforce camelCase naming convention */
    '@typescript-eslint/camelcase': 'off',
    /* Enforce the consistent use of either backticks, double, or single quotes */
    '@typescript-eslint/quotes': 'off',
    /* Require or disallow semicolons instead of ASI */
    '@typescript-eslint/semi': 'off',
    /* Enforce consistent indentation */
    '@typescript-eslint/indent': 'off',
    /* Disallow unnecessary parentheses */
    '@typescript-eslint/no-extra-parens': 'off',

    /* Disabled */
    /* Disallow the use of parameter properties in class constructors */
    '@typescript-eslint/no-parameter-properties': 'off',
    /* Enforce template literal expressions to be of string type */
    '@typescript-eslint/restrict-template-expressions': 'off',
    /* Requires type annotations to exist */
    '@typescript-eslint/typedef': 'off',
    /* Disallows magic numbers */
    '@typescript-eslint/no-magic-numbers': 'off',
    /* Requires Promise-like values to be handled appropriately. */
    '@typescript-eslint/no-floating-promises': 'off',
    /* Disallow the use of type aliases */
    '@typescript-eslint/no-type-alias': 'off',
    /* Disallows non-null assertions using the ! postfix operator */
    '@typescript-eslint/no-non-null-assertion': 'off',
    /* Restricts the types allowed in boolean expressions */
    '@typescript-eslint/strict-boolean-expressions': 'off',
    /* Disallow the use of custom TypeScript modules and namespaces */
    '@typescript-eslint/no-namespace': 'off',
    ///* Avoid using promises in places not designed to handle them */
    '@typescript-eslint/no-misused-promises': 'off',
    /* Prevents conditionals where the type is always truthy or always falsy */
    '@typescript-eslint/no-unnecessary-condition': 'off',
    /* Enforces naming of generic type variables */
    '@typescript-eslint/generic-type-naming': 'off',
    /* Require that interface names should or should not prefixed with I */
    '@typescript-eslint/interface-name-prefix': 'off',
    /* Disallows invocation of require() */
    '@typescript-eslint/no-require-imports': 'off',
    /* Sets preference level for triple slash directives versus ES6-style import declarations */
    '@typescript-eslint/triple-slash-reference': 'off',

    /* Enabled */
    /* Requires using either T[] or Array<T> for arrays */
    '@typescript-eslint/array-type': 'warn',
    /* Bans specific types from being used */
    '@typescript-eslint/ban-types': [
      'warn',
      {
        types: {
          String: {
            message: 'Use string instead',
            fixWith: 'string',
          },
          Boolean: {
            message: 'Use boolean instead',
            fixWith: 'boolean',
          },
          Number: {
            message: 'Use number instead',
            fixWith: 'number',
          },
          Symbol: {
            message: 'Use symbol instead',
            fixWith: 'symbol',
          },
          Function: {
            message: [
              'The `Function` type accepts any function-like value.',
              'It provides no type safety when calling the function, which can be a common source of bugs.',
              'It also accepts things like class declarations, which will throw at runtime as they will not be called with `new`.',
              'If you are expecting the function to accept certain arguments, you should explicitly define the function shape.',
            ].join('\n'),
          },
          Object: {
            message: [
              'The `Object` type actually means "any non-nullish value", so it is marginally better than `unknown`.',
              '- If you want a type meaning "any object", you probably want `Record<string, unknown>` instead.',
              '- If you want a type meaning "any value", you probably want `unknown` instead.',
            ].join('\n'),
          },
        },
        extendDefaults: false,
      },
    ],
    /* Bans “// @ts-ignore” comments from being used */
    '@typescript-eslint/ban-ts-comment': [
      'warn',
      {
        'ts-expect-error': 'allow-with-description',
        'ts-ignore': true,
        'ts-nocheck': true,
        'ts-check': false,
        minimumDescriptionLength: 5,
      },
    ],
    '@typescript-eslint/consistent-type-definitions': ['warn', 'interface'],
    /* Require explicit return types on functions and class methods */
    '@typescript-eslint/explicit-function-return-type': [
      'warn',
      {
        allowExpressions: true,
        allowTypedFunctionExpressions: true,
        allowHigherOrderFunctions: true,
        allowConciseArrowFunctionExpressionsStartingWithVoid: true,
      },
    ],
    '@typescript-eslint/explicit-module-boundary-types': 'off',
    '@typescript-eslint/no-empty-function': ['warn', { allow: ['arrowFunctions'] }],
    '@typescript-eslint/no-explicit-any': 'warn',
    '@typescript-eslint/no-var-requires': 'off',
    '@typescript-eslint/prefer-nullish-coalescing': 'off',
    '@typescript-eslint/prefer-optional-chain': 'off',
    '@typescript-eslint/unbound-method': 'off',
    '@typescript-eslint/prefer-as-const': 'error',
    '@typescript-eslint/no-unused-vars': [
      'warn',
      { varsIgnorePattern: '^_{1,2}[^_]', argsIgnorePattern: '^_{1,2}[^_]' },
    ],
    '@typescript-eslint/explicit-member-accessibility': 'warn',
    '@typescript-eslint/no-unsafe-assignment': 'warn',
    '@typescript-eslint/no-unsafe-call': 'warn',
    '@typescript-eslint/no-unsafe-member-access': 'warn',
    '@typescript-eslint/no-unsafe-return': 'off',
    '@typescript-eslint/restrict-plus-operands': 'warn',
    '@typescript-eslint/naming-convention': [
      'warn',

      /* Fields */
      {
        selector: ['variableLike'],
        format: ['camelCase', 'StrictPascalCase', 'UPPER_CASE'],
        leadingUnderscore: 'allowSingleOrDouble',
      },

      /* Private */
      {
        selector: ['memberLike'],
        modifiers: ['private'],
        format: ['camelCase', 'StrictPascalCase', 'UPPER_CASE'],
        leadingUnderscore: 'require',
      },

      /* Protected */
      {
        selector: ['memberLike'],
        modifiers: ['protected'],
        format: ['camelCase', 'StrictPascalCase', 'UPPER_CASE'],
        leadingUnderscore: 'forbid',
      },

      /* Public */
      {
        selector: ['memberLike'],
        modifiers: ['public'],
        format: ['camelCase', 'StrictPascalCase', 'UPPER_CASE'],
        leadingUnderscore: 'forbid',
      },

      /* Private Class Methods */
      {
        selector: ['classMethod'],
        modifiers: ['private'],
        format: ['StrictPascalCase'],
        leadingUnderscore: 'require',
      },

      /* Protected Class Methods */
      {
        selector: ['classMethod'],
        modifiers: ['protected'],
        format: ['StrictPascalCase'],
        leadingUnderscore: 'forbid',
      },

      /* Public Class Methods */
      {
        selector: ['classMethod'],
        modifiers: ['public'],
        format: ['StrictPascalCase'],
        leadingUnderscore: 'forbid',
      },

      /* Ignore Destructured Naming */
      {
        selector: ['variable'],
        modifiers: ['destructured'],
        format: null,
      },

      /* Ignore Quoted */
      {
        selector: [
          'classProperty',
          'objectLiteralProperty',
          'typeProperty',
          'classMethod',
          'objectLiteralMethod',
          'typeMethod',
          'accessor',
          'enumMember',
        ],
        format: null,
        modifiers: ['requiresQuotes'],
      },

      /* Ignore Object Literals */
      {
        selector: ['objectLiteralProperty', 'objectLiteralMethod'],
        format: null,
      },

      /* Boolean Naming */
      {
        selector: ['variable'],
        types: ['boolean'],
        format: ['camelCase', 'StrictPascalCase'],
        prefix: ['is', 'should', 'has', 'can', 'did', 'will', 'was'],
        leadingUnderscore: 'allowSingleOrDouble',
      },

      /* Ignore Interfaces */
      {
        selector: ['typeProperty'],
        format: null,
      },
    ],
  },
  overrides: [
    {
      /* Config Files */
      files: '*rc.js',
      rules: {
        'sort-keys': 'off',
        'sort-keys-fix/sort-keys-fix': 'off',
      },
    },
    {
      /* Test Files */
      files: '*.spec.ts',
      env: {
        'jest/globals': true,
      },
      plugins: ['jest'],
      rules: {
        'jest/no-disabled-tests': 'warn',
        'jest/no-focused-tests': 'error',
        'jest/no-alias-methods': 'error',
        'jest/no-identical-title': 'error',
        'jest/no-jasmine-globals': 'error',
        'jest/no-jest-import': 'error',
        'jest/no-test-prefixes': 'error',
        'jest/no-test-return-statement': 'error',
        'jest/prefer-to-have-length': 'warn',
        'jest/prefer-spy-on': 'error',
        'jest/valid-expect': 'error',
      },
    },
  ],
};
