# Changelog

## [2.0.2] - 2020-04-23

- Scheduler: Prevents duplicate runs from occuring
- Scheduler: Forwards function return value to postrun event.
- Scheduler: Added #IsRunning() method.

## [2.0.1] - 2020-12-16

- Properly export throttlers.

## [2.0.0] - 2020-12-07

- Removed helix-authenticator.
- Removed type-safe event emitter.
- Updated logger.
- Updated filter-object.
- Updated throttlers.
- Updated sync-list.
- Updated sleeper and bundle other time helpers.
- Updated validator.
- Updated api-base.
- Updated dependencies.
- Refactored request-loop into scheduler.
- Added additional data structures for queues and distributed scheduling of tasks.

## [1.3.0] - 2020-12-04

- Renamed the logger factory from `loggerFactory` to `createLogger`.
- Renamed the project from ts-api-tools to ts-utilities
- Upgraded the TypeScript skeleton to support the new CI.
- Updated the logger to support more options like log level.

## [1.2.0] - 2020-08-12

- Modified APIBase to provide a `body` field which is populated with the raw body content. This is useful for debugging bad validations. The error generic has also be renamed to `APIError` as to avoid declaration merging with the native `Error` interface.
- Added a new class: TypeSafeEventEmitter. A strongly typed utility to build event emitters. Has a factory: `TypeSafeEventEmitterFactory`.
- Updated the logger to now provide internal color support for development, sprintf token support and shorter logs for production.
- Updated to the latest TS skeleton.
- Updated linting to comply with the new TS skeleton linting rules.

## [1.1.0] - 2020-07-01

- Add http(s) agents for handling keep-alive sockets to make sequential requests quicker.
- Updated to latest `typescript-skeleton`.

## [1.0.4] - 2020-05-26

- SleeperFactory now rounds decimal sleep values to be compatible with throttlers.
- Additional tests have been added to check for decimal validation in SleeperFactory.

## [1.0.3] - 2020-05-15

- The typescript-skeleton has been upgraded, this means the comments suppressing linting warns in tests files have been removed.
- There is much greater test coverage, as every file has tests now. This currently stands at 118 passing tests (96.9% coverage).
- Parameter validation in the existing factories has become even stronger.
- A bug with setting the request headers for APIBase URL encoded POST requests has been fixed.
- Factories have been made and exported for all classes.

## [1.0.2] - 2020-05-14

- Properly export HelixAuthenticatorFactory

## [1.0.1] - 2020-05-14

- Properly export HelixAuthenticator
- All factories have been migrated from static methods to a separate export. This is a reverted change - this gives us the flexibility to extend a class via a public constructor whilst also allowing a static factory.

## [1.0.0] - 2020-05-06

- New linting has been adopted.
- The project has been updated to reflect the new code-style.
- Some files have been shifted around to improve organisation and bring clarity on what directories contain.
- All relevant classes, methods and functions exported now have rich JS Doc comments added.
- The package now has full test coverage.
- All factories have been migrated to a static method in the class they belong too.
- Exports have been changed to star syntax, and each file is now responsible for it's exports.
- HelixThrottler now ignores the internal sleep calls if the time to sleep is <= 0.
- The HelixAuthenticator class has been added - which provides an easy way to get access tokens for the public Twitch Helix API.

## [0.2.0] - 2020-05-05

- Adds logger with label support and automated conditions for loglevel printing in prod/dev environments.
