# ts-utilities

A collection of utilities shared across services and libraries.

## Usage

### Logger

Debug output is only printed to stdout when `NODE_ENV=development`.
All output is hidden when `NODE_ENV=test` or `NODE_ENV=ci` which are automatically set by **Mocha** and **Jenkins** respectively.

```ts
import { CreateLogger, Logger } from 'vapour-utilities';

/* Pre-initialised instance */
Logger.info('NaM');

/* Initialise your own logger instance */
const myOwnLogger = CreateLogger();
myOwnLogger.error('Redis connection fatal! Reconnecting in 5s...');

/* Label your own logger */
const labeledLogger = CreateLogger('SERVICE');
labeledLogger.info('I did a thing');
```

## Tests

To run the test suite, first install the dependencies, then run `npm test`:

```bash
$ npm install
$ npm run test
```
