import { FilterObject } from './filter-object';

describe('filterObject', () => {
  describe('#filterObject()', () => {
    it('should filter keys provided', () => {
      const original = { a: 50, b: 30, c: 10, d: 1000 } as const;
      const result = FilterObject(original, ['a', 'c']);

      expect(typeof result).toBe('object');
      expect(Object.keys(result)).toHaveLength(2);
      expect(result.a).toBe(original.a);
      expect(result.c).toBe(original.c);
    });

    it('should trim string keys', () => {
      const original = { '  hello ': 10 } as const;
      const result = FilterObject(original, ['  hello '], true);

      expect(typeof result).toBe('object');
      expect(Object.keys(result)).toHaveLength(1);
      expect(result['hello']).toEqual(original['  hello ']);
    });

    it('should not trim non-strings', () => {
      const symbolKey: unique symbol = Symbol('test');
      const original = { 3: 100, [symbolKey]: 90 } as const;
      expect(() => FilterObject(original, [3, symbolKey], true)).not.toThrow();
    });
  });
});
