import type { TrimWhitespace } from './trim';

type Merge<T extends object> = (T extends object ? (x: T) => unknown : never) extends (
  x: infer R
) => unknown
  ? R
  : {};

export type FilteredObject<
  Obj extends object,
  Keys extends (keyof Obj)[],
  Trim extends boolean
> = Merge<
  {
    [K in Keys[number]]: {
      [R in Trim extends true ? (K extends string ? TrimWhitespace<K> : K) : K]: Obj[K];
    };
  }[Keys[number]]
>;
