import { CreateLogger } from './logger';

describe('Logger', () => {
  describe('#createLogger()', () => {
    it('Should return a winston logger instance', () => {
      expect(CreateLogger()).not.toBeUndefined();
    });

    it('Should be silent in test mode', () => {
      expect(CreateLogger({ silent: true }).silent).toBeTruthy();
    });

    it('Should not be silent in production mode', () => {
      expect(CreateLogger({ silent: false }).silent).toBeFalsy();
    });

    it('Should enable silly logging in development', () => {
      expect(CreateLogger({ level: 'silly' }).level).toEqual('silly');
    });
  });
});
