import { Sleeper } from '../time/sleeper';
import { Scheduler } from './scheduler';

describe('Scheduler', () => {
  it('Should expect Scheduler to run with expected intervals', async () => {
    let counter = 0;
    let didCauseError = false;
    let isLastStateError = false;

    const fn = (): void => {
      counter++;
      if (didCauseError) throw new Error('Dummy error');
    };

    const scheduler = new Scheduler({ interval: 50, task: fn });
    scheduler.on('postrun', () => (isLastStateError = false));
    scheduler.on('error', () => (isLastStateError = true));

    // Timer inactive and should not run function
    await Sleeper.Sleep(100);
    expect(counter).toBe(0);
    expect(isLastStateError).toBe(false);

    // Manually trigger function
    scheduler.Execute();
    await Sleeper.Sleep(100);
    expect(counter).toBe(1);
    expect(isLastStateError).toBe(false);

    // Activate timer
    const run = scheduler.Start();
    await Sleeper.Sleep(500);
    expect(isLastStateError).toBe(false);

    // Stop timer
    scheduler.Stop();
    expect(counter).toBeGreaterThan(7);
    expect(isLastStateError).toBe(false);

    // Reset counter value and test that manual trigger calls the function once
    counter = 0;
    didCauseError = true;
    scheduler.Execute();
    await Sleeper.Sleep(200);
    expect(counter).toBe(1);
    expect(isLastStateError).toBe(true);

    // Stop loop and wait for it to finish
    scheduler.Stop();
    await run;
  });
});
