/**
 * @description Calculates the time difference between the first and second call of this reference.
 * @returns A function which returns the difference from the first invocation.
 */
export function timeDifference(): () => number {
  const start = process.hrtime();
  return (): number => {
    const [s, ns] = process.hrtime(start);
    return s * 1e3 + ns / 1e6;
  };
}
