import { timeDifference } from '../difference';
import { Sleeper } from './sleeper';

describe('Sleeper', () => {
  /* 10 trials at 15% tolerance */
  const trials = 10;
  const instabilityTolerance = 0.15;
  const waitTime = 100;

  const lowerBound = waitTime * (1 - instabilityTolerance);
  const upperBound = waitTime * (1 + instabilityTolerance);

  let sleeper!: Sleeper;
  beforeEach(() => (sleeper = new Sleeper(waitTime)));

  describe('methods', () => {
    describe('#wait()', () => {
      for (let i = 0; i < trials; i++) {
        it('should wait the duration', async () => {
          const end = timeDifference();
          await sleeper.Wait();
          const diff = end();
          expect(diff).toBeGreaterThan(lowerBound);
          expect(diff).toBeLessThan(upperBound);
        });
      }
    });

    describe('#end()', () => {
      it('should make the sleeper end early', async () => {
        const end = timeDifference();
        await new Promise(r => {
          sleeper.Wait().then(r);
          sleeper.End();
        });
        const diff = end();
        expect(diff).toBeLessThan(lowerBound);
      });
    });
  });
});
