import { Validator } from './validator';

describe('Validator', () => {
  const schema = {
    definitions: {
      foo: {
        properties: {
          bar: {
            type: 'number',
          },
          baz: {
            $ref: '#/definitions/quux',
          },
        },
        required: ['bar'],
        type: 'object',
      },
      quux: {
        properties: {
          corge: {
            $ref: '#/definitions/foo',
          },
        },
        required: ['corge'],
        type: 'object',
      },
    },
  };

  let validator: Validator;
  beforeEach(() => (validator = new Validator(schema)));
  afterEach(() => (validator = undefined as never));

  describe('methods', () => {
    describe('#Validate()', () => {
      it('should pass validation', () => {
        expect(validator.Validate({ bar: 30 }, 'foo').valid).toBeTruthy();
      });

      it('should not pass validation', () => {
        expect(validator.Validate({ bar: 'baz' }, 'foo', false).valid).toBeFalsy();
      });

      it('should recursively validate', () => {
        expect(
          validator.Validate(
            {
              corge: {
                bar: 10,
                baz: {
                  corge: {
                    bar: 30,
                  },
                },
              },
            },
            'quux'
          ).valid
        ).toBeTruthy();
      });

      it('should throw errors', () => {
        expect(() => validator.Validate({ bar: 'baz' }, 'foo', true).valid).toThrow();
      });

      it('should not throw errors', () => {
        expect(() => validator.Validate({ bar: 'baz' }, 'foo', false).valid).not.toThrow();
      });
    });
  });
});
