#!/bin/sh

version=${version:-$(git describe 2>/dev/null | cut -b2-)}

for v in $(git for-each-ref --format='%(refname:short)' refs/remotes/origin --contains); do
    v=$(echo "$v" | sed 's/^origin\///')
    if [ "$(echo "$v" | cut -d'/' -f1)" = "release" ]; then
        version="v$(echo "$v" | cut -d'/' -f2)"
    fi
done

if [ -z "$version"  ]; then
    if [ -n "$GIT_RELEASE"  ]; then
        version="$(echo "$GIT_RELEASE" | cut -b2-)"
    else
        version="dev"
    fi
fi

new_version_path="$(mktemp)"

echo "export const VERSION = '$version';" > "$new_version_path"

if ! diff src/version.ts "$new_version_path" 2>/dev/null 1>&2; then
    echo "New version: $version"
    mv "$new_version_path" src/version.ts
fi

rm -f src/new-version.ts
